#include "DisplayObjects.h"

#ifdef __APPLE__
#include <GLUT/glut.h>
#include <OpenGL/gl.h>
#else
#include <GL/glut.h>
#include <GL/gl.h>
#endif

#include <math.h>

#include "Vector.h"

#define COLORED_SPHERE_PRECISION 32

#define drawColoredSphere_drawSide(x_macro, y_macro, z_macro) \
	for (vertexIndexY = 0; vertexIndexY < COLORED_SPHERE_PRECISION; vertexIndexY++) { \
		for (vertexIndexX = 0; vertexIndexX < COLORED_SPHERE_PRECISION; vertexIndexX++) { \
			vector.x = x_macro(0, 0); \
			vector.y = y_macro(0, 0); \
			vector.z = z_macro(0, 0); \
			Vector_normalize(&vector); \
			glNormal3f(vector.x, vector.y, vector.z); \
			glVertex3f(vector.x, vector.y, vector.z); \
			vector.x = x_macro(1, 0); \
			vector.y = y_macro(1, 0); \
			vector.z = z_macro(1, 0); \
			Vector_normalize(&vector); \
			glNormal3f(vector.x, vector.y, vector.z); \
			glVertex3f(vector.x, vector.y, vector.z); \
			vector.x = x_macro(1, 1); \
			vector.y = y_macro(1, 1); \
			vector.z = z_macro(1, 1); \
			Vector_normalize(&vector); \
			glNormal3f(vector.x, vector.y, vector.z); \
			glVertex3f(vector.x, vector.y, vector.z); \
			vector.x = x_macro(0, 1); \
			vector.y = y_macro(0, 1); \
			vector.z = z_macro(0, 1); \
			Vector_normalize(&vector); \
			glNormal3f(vector.x, vector.y, vector.z); \
			glVertex3f(vector.x, vector.y, vector.z); \
		} \
	}

#define drawColoredSphere_drawSide_positiveOne(x, y) 1.0f
#define drawColoredSphere_drawSide_negativeOne(x, y) -1.0f
#define drawColoredSphere_drawSide_positiveVertexX(x, y) (2.0f * (vertexIndexX + x) / COLORED_SPHERE_PRECISION) - 1.0f
#define drawColoredSphere_drawSide_negativeVertexX(x, y) (-2.0f * (vertexIndexX + x) / COLORED_SPHERE_PRECISION) + 1.0f
#define drawColoredSphere_drawSide_positiveVertexY(x, y) (2.0f * (vertexIndexY + y) / COLORED_SPHERE_PRECISION) - 1.0f
#define drawColoredSphere_drawSide_negativeVertexY(x, y) (-2.0f * (vertexIndexY + y) / COLORED_SPHERE_PRECISION) + 1.0f

static void drawColoredSphere(float redPX, float greenPX, float bluePX, float alphaPX,
                              float redPY, float greenPY, float bluePY, float alphaPY,
                              float redPZ, float greenPZ, float bluePZ, float alphaPZ,
                              float redNX, float greenNX, float blueNX, float alphaNX,
                              float redNY, float greenNY, float blueNY, float alphaNY,
                              float redNZ, float greenNZ, float blueNZ, float alphaNZ) {
	int vertexIndexX, vertexIndexY;
	Vector vector;
	
	glBegin(GL_QUADS);
	glColor4f(redPX, greenPX, bluePX, alphaPX);
	drawColoredSphere_drawSide(drawColoredSphere_drawSide_positiveOne, drawColoredSphere_drawSide_positiveVertexY, drawColoredSphere_drawSide_negativeVertexX);
	glColor4f(redPY, greenPY, bluePY, alphaPY);
	drawColoredSphere_drawSide(drawColoredSphere_drawSide_positiveVertexX, drawColoredSphere_drawSide_positiveOne, drawColoredSphere_drawSide_negativeVertexY);
	glColor4f(redPZ, greenPZ, bluePZ, alphaPZ);
	drawColoredSphere_drawSide(drawColoredSphere_drawSide_positiveVertexX, drawColoredSphere_drawSide_positiveVertexY, drawColoredSphere_drawSide_positiveOne);
	glColor4f(redNX, greenNX, blueNX, alphaNX);
	drawColoredSphere_drawSide(drawColoredSphere_drawSide_negativeOne, drawColoredSphere_drawSide_positiveVertexY, drawColoredSphere_drawSide_positiveVertexX);
	glColor4f(redNY, greenNY, blueNY, alphaNY);
	drawColoredSphere_drawSide(drawColoredSphere_drawSide_positiveVertexX, drawColoredSphere_drawSide_negativeOne, drawColoredSphere_drawSide_positiveVertexY);
	glColor4f(redNZ, greenNZ, blueNZ, alphaNZ);
	drawColoredSphere_drawSide(drawColoredSphere_drawSide_negativeVertexX, drawColoredSphere_drawSide_positiveVertexY, drawColoredSphere_drawSide_negativeOne);
	glEnd();
}

void drawAxisColoredSphere() {
	drawColoredSphere(1.0f, 0.0f, 0.0f, 1.0f,
	                  0.0f, 1.0f, 0.0f, 1.0f,
	                  0.0f, 0.0f, 1.0f, 1.0f,
	                  0.0f, 1.0f, 1.0f, 1.0f,
	                  1.0f, 0.0f, 1.0f, 1.0f,
	                  1.0f, 1.0f, 0.0f, 1.0f);
}

void drawSingleColoredSphere(float red, float green, float blue, float alpha) {
	drawColoredSphere(red, green, blue, alpha,
	                  red, green, blue, alpha,
	                  red, green, blue, alpha,
	                  red, green, blue, alpha,
	                  red, green, blue, alpha,
	                  red, green, blue, alpha);
}

#define TEXT_OFFSET_X 8
#define TEXT_OFFSET_Y 5

void drawAxisCross() {
	GLdouble modelviewMatrix[16], projectionMatrix[16];
	GLint viewport[4];
	GLdouble winX, winY, winZ, objX, objY, objZ;
	
	glBegin(GL_QUADS);
	glColor3f(1.0f, 0.0f, 0.0f);
	glNormal3f(-1.0f, 0.0f, 0.0f);
	glVertex3f(-0.7f, -0.1f, -0.1f);
	glVertex3f(-0.7f, -0.1f, 0.1f);
	glVertex3f(-0.7f, 0.1f, 0.1f);
	glVertex3f(-0.7f, 0.1f, -0.1f);
	glNormal3f(1.0f, 0.0f, 0.0f);
	glVertex3f(0.7f, -0.1f, 0.1f);
	glVertex3f(0.7f, -0.1f, -0.1f);
	glVertex3f(0.7f, 0.1f, -0.1f);
	glVertex3f(0.7f, 0.1f, 0.1f);
	glNormal3f(0.0f, -1.0f, 0.0f);
	glVertex3f(-0.7f, -0.1f, -0.1f);
	glVertex3f(0.7f, -0.1f, -0.1f);
	glVertex3f(0.7f, -0.1f, 0.1f);
	glVertex3f(-0.7f, -0.1f, 0.1f);
	glNormal3f(0.0f, 1.0f, 0.0f);
	glVertex3f(-0.7f, 0.1f, 0.1f);
	glVertex3f(0.7f, 0.1f, 0.1f);
	glVertex3f(0.7f, 0.1f, -0.1f);
	glVertex3f(-0.7f, 0.1f, -0.1f);
	glNormal3f(0.0f, 0.0f, -1.0f);
	glVertex3f(0.7f, -0.1f, -0.1f);
	glVertex3f(-0.7f, -0.1f, -0.1f);
	glVertex3f(-0.7f, 0.1f, -0.1f);
	glVertex3f(0.7f, 0.1f, -0.1f);
	glNormal3f(0.0f, 0.0f, -1.0f);
	glVertex3f(-0.7f, -0.1f, 0.1f);
	glVertex3f(0.7f, -0.1f, 0.1f);
	glVertex3f(0.7f, 0.1f, 0.1f);
	glVertex3f(-0.7f, 0.1f, 0.1f);
	
	glColor3f(0.0f, 1.0f, 0.0f);
	glNormal3f(0.0f, -1.0f, 0.0f);
	glVertex3f(-0.1f, -0.7f, -0.1f);
	glVertex3f(0.1f, -0.7f, -0.1f);
	glVertex3f(0.1f, -0.7f, 0.1f);
	glVertex3f(-0.1f, -0.7f, 0.1f);
	glNormal3f(0.0f, 1.0f, 0.0f);
	glVertex3f(-0.1f, 0.7f, 0.1f);
	glVertex3f(0.1f, 0.7f, 0.1f);
	glVertex3f(0.1f, 0.7f, -0.1f);
	glVertex3f(-0.1f, 0.7f, -0.1f);
	glNormal3f(-1.0f, 0.0f, 0.0f);
	glVertex3f(-0.1f, -0.7f, -0.1f);
	glVertex3f(-0.1f, -0.7f, 0.1f);
	glVertex3f(-0.1f, 0.7f, 0.1f);
	glVertex3f(-0.1f, 0.7f, -0.1f);
	glNormal3f(1.0f, 0.0f, 0.0f);
	glVertex3f(0.1f, -0.7f, 0.1f);
	glVertex3f(0.1f, -0.7f, -0.1f);
	glVertex3f(0.1f, 0.7f, -0.1f);
	glVertex3f(0.1f, 0.7f, 0.1f);
	glNormal3f(0.0f, 0.0f, -1.0f);
	glVertex3f(0.1f, -0.7f, -0.1f);
	glVertex3f(-0.1f, -0.7f, -0.1f);
	glVertex3f(-0.1f, 0.7f, -0.1f);
	glVertex3f(0.1f, 0.7f, -0.1f);
	glNormal3f(0.0f, 0.0f, 1.0f);
	glVertex3f(-0.1f, -0.7f, 0.1f);
	glVertex3f(0.1f, -0.7f, 0.1f);
	glVertex3f(0.1f, 0.7f, 0.1f);
	glVertex3f(-0.1f, 0.7f, 0.1f);
	
	glColor3f(0.0f, 0.0f, 1.0f);
	glNormal3f(0.0f, 0.0f, -1.0f);
	glVertex3f(0.1f, -0.1f, -0.7f);
	glVertex3f(-0.1f, -0.1f, -0.7f);
	glVertex3f(-0.1f, 0.1f, -0.7f);
	glVertex3f(0.1f, 0.1f, -0.7f);
	glNormal3f(0.0f, 0.0f, 1.0f);
	glVertex3f(-0.1f, -0.1f, 0.7f);
	glVertex3f(0.1f, -0.1f, 0.7f);
	glVertex3f(0.1f, 0.1f, 0.7f);
	glVertex3f(-0.1f, 0.1f, 0.7f);
	glNormal3f(-1.0f, 0.0f, 0.0f);
	glVertex3f(-0.1f, -0.1f, -0.7f);
	glVertex3f(-0.1f, -0.1f, 0.7f);
	glVertex3f(-0.1f, 0.1f, 0.7f);
	glVertex3f(-0.1f, 0.1f, -0.7f);
	glNormal3f(1.0f, 0.0f, 0.0f);
	glVertex3f(0.1f, -0.1f, 0.7f);
	glVertex3f(0.1f, -0.1f, -0.7f);
	glVertex3f(0.1f, 0.1f, -0.7f);
	glVertex3f(0.1f, 0.1f, 0.7f);
	glNormal3f(0.0f, -1.0f, 0.0f);
	glVertex3f(-0.1f, -0.1f, -0.7f);
	glVertex3f(0.1f, -0.1f, -0.7f);
	glVertex3f(0.1f, -0.1f, 0.7f);
	glVertex3f(-0.1f, -0.1f, 0.7f);
	glNormal3f(0.0f, 1.0f, 0.0f);
	glVertex3f(-0.1f, 0.1f, 0.7f);
	glVertex3f(0.1f, 0.1f, 0.7f);
	glVertex3f(0.1f, 0.1f, -0.7f);
	glVertex3f(-0.1f, 0.1f, -0.7f);
	glEnd();
	
	glPushAttrib(GL_ENABLE_BIT);
	glDisable(GL_LIGHTING);
	
	glGetDoublev(GL_MODELVIEW_MATRIX, modelviewMatrix);
	glGetDoublev(GL_PROJECTION_MATRIX, projectionMatrix);
	glGetIntegerv(GL_VIEWPORT, viewport);
	
	glColor3f(1.0f, 0.0f, 0.0f);
	gluProject(-1.0f, 0.0f, 0.0f, modelviewMatrix, projectionMatrix, viewport, &winX, &winY, &winZ);
	gluUnProject(winX - TEXT_OFFSET_X, winY - TEXT_OFFSET_Y, winZ, modelviewMatrix, projectionMatrix, viewport, &objX, &objY, &objZ);
	glRasterPos3f(objX, objY, objZ);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, '-');
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, 'X');
	gluProject(1.0f, 0.0f, 0.0f, modelviewMatrix, projectionMatrix, viewport, &winX, &winY, &winZ);
	gluUnProject(winX - TEXT_OFFSET_X, winY - TEXT_OFFSET_Y, winZ, modelviewMatrix, projectionMatrix, viewport, &objX, &objY, &objZ);
	glRasterPos3f(objX, objY, objZ);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, '+');
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, 'X');
	
	glColor3f(0.0f, 1.0f, 0.0f);
	gluProject(0.0f, -1.0f, 0.0f, modelviewMatrix, projectionMatrix, viewport, &winX, &winY, &winZ);
	gluUnProject(winX - TEXT_OFFSET_X, winY - TEXT_OFFSET_Y, winZ, modelviewMatrix, projectionMatrix, viewport, &objX, &objY, &objZ);
	glRasterPos3f(objX, objY, objZ);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, '-');
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, 'Y');
	gluProject(0.0f, 1.0f, 0.0f, modelviewMatrix, projectionMatrix, viewport, &winX, &winY, &winZ);
	gluUnProject(winX - TEXT_OFFSET_X, winY - TEXT_OFFSET_Y, winZ, modelviewMatrix, projectionMatrix, viewport, &objX, &objY, &objZ);
	glRasterPos3f(objX, objY, objZ);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, '+');
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, 'Y');
	
	glColor3f(0.0f, 0.0f, 1.0f);
	gluProject(0.0f, 0.0f, -1.0f, modelviewMatrix, projectionMatrix, viewport, &winX, &winY, &winZ);
	gluUnProject(winX - TEXT_OFFSET_X, winY - TEXT_OFFSET_Y, winZ, modelviewMatrix, projectionMatrix, viewport, &objX, &objY, &objZ);
	glRasterPos3f(objX, objY, objZ);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, '-');
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, 'Z');
	gluProject(0.0f, 0.0f, 1.0f, modelviewMatrix, projectionMatrix, viewport, &winX, &winY, &winZ);
	gluUnProject(winX - TEXT_OFFSET_X, winY - TEXT_OFFSET_Y, winZ, modelviewMatrix, projectionMatrix, viewport, &objX, &objY, &objZ);
	glRasterPos3f(objX, objY, objZ);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, '+');
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, 'Z');
	
	glPopAttrib();
}

void drawWireMesh() {
	glColor3f(0.2f, 0.2f, 0.2f);
	glBegin(GL_LINES);
	glNormal3f(0.0f, 1.0f, 0.0f);
	glVertex3f(-1.1f, -1.1f, -1.1f);
	glVertex3f(-1.1f, -1.1f, 1.1f);
	glVertex3f(-0.55f, -1.1f, -1.1f);
	glVertex3f(-0.55f, -1.1f, 1.1f);
	glVertex3f(0.0f, -1.1f, -1.1f);
	glVertex3f(0.0f, -1.1f, 1.1f);
	glVertex3f(0.55f, -1.1f, -1.1f);
	glVertex3f(0.55f, -1.1f, 1.1f);
	glVertex3f(1.1f, -1.1f, -1.1f);
	glVertex3f(1.1f, -1.1f, 1.1f);
	glVertex3f(-1.1f, -1.1f, -1.1f);
	glVertex3f(1.1f, -1.1f, -1.1f);
	glVertex3f(-1.1f, -1.1f, -0.55f);
	glVertex3f(1.1f, -1.1f, -0.55f);
	glVertex3f(-1.1f, -1.1f, 0.0f);
	glVertex3f(1.1f, -1.1f, 0.0f);
	glVertex3f(-1.1f, -1.1f, 0.55f);
	glVertex3f(1.1f, -1.1f, 0.55f);
	glVertex3f(-1.1f, -1.1f, 1.1f);
	glVertex3f(1.1f, -1.1f, 1.1f);
	
	glNormal3f(0.0f, -1.0f, 0.0f);
	glVertex3f(-1.1f, 1.1f, -1.1f);
	glVertex3f(-1.1f, 1.1f, 1.1f);
	glVertex3f(-0.55f, 1.1f, -1.1f);
	glVertex3f(-0.55f, 1.1f, 1.1f);
	glVertex3f(0.0f, 1.1f, -1.1f);
	glVertex3f(0.0f, 1.1f, 1.1f);
	glVertex3f(0.55f, 1.1f, -1.1f);
	glVertex3f(0.55f, 1.1f, 1.1f);
	glVertex3f(1.1f, 1.1f, -1.1f);
	glVertex3f(1.1f, 1.1f, 1.1f);
	glVertex3f(-1.1f, 1.1f, -1.1f);
	glVertex3f(1.1f, 1.1f, -1.1f);
	glVertex3f(-1.1f, 1.1f, -0.55f);
	glVertex3f(1.1f, 1.1f, -0.55f);
	glVertex3f(-1.1f, 1.1f, 0.0f);
	glVertex3f(1.1f, 1.1f, 0.0f);
	glVertex3f(-1.1f, 1.1f, 0.55f);
	glVertex3f(1.1f, 1.1f, 0.55f);
	glVertex3f(-1.1f, 1.1f, 1.1f);
	glVertex3f(1.1f, 1.1f, 1.1f);
	
	glNormal3f(1.0f, 0.0f, 0.0f);
	glVertex3f(-1.1f, -1.1f, -0.55f);
	glVertex3f(-1.1f, 1.1f, -0.55f);
	glVertex3f(-1.1f, -1.1f, 0.0f);
	glVertex3f(-1.1f, 1.1f, 0.0f);
	glVertex3f(-1.1f, -1.1f, 0.55f);
	glVertex3f(-1.1f, 1.1f, 0.55f);
	glVertex3f(-1.1f, -1.1f, 1.1f);
	glVertex3f(-1.1f, 1.1f, 1.1f);
	glVertex3f(-1.1f, -0.55f, -1.1f);
	glVertex3f(-1.1f, -0.55f, 1.1f);
	glVertex3f(-1.1f, 0.0f, -1.1f);
	glVertex3f(-1.1f, 0.0f, 1.1f);
	glVertex3f(-1.1f, 0.55f, -1.1f);
	glVertex3f(-1.1f, 0.55f, 1.1f);
	
	glNormal3f(-1.0f, 0.0f, 0.0f);
	glVertex3f(1.1f, -1.1f, -0.55f);
	glVertex3f(1.1f, 1.1f, -0.55f);
	glVertex3f(1.1f, -1.1f, 0.0f);
	glVertex3f(1.1f, 1.1f, 0.0f);
	glVertex3f(1.1f, -1.1f, 0.55f);
	glVertex3f(1.1f, 1.1f, 0.55f);
	glVertex3f(1.1f, -1.1f, 1.1f);
	glVertex3f(1.1f, 1.1f, 1.1f);
	glVertex3f(1.1f, -0.55f, -1.1f);
	glVertex3f(1.1f, -0.55f, 1.1f);
	glVertex3f(1.1f, 0.0f, -1.1f);
	glVertex3f(1.1f, 0.0f, 1.1f);
	glVertex3f(1.1f, 0.55f, -1.1f);
	glVertex3f(1.1f, 0.55f, 1.1f);
	
	glNormal3f(0.0f, 0.0f, 1.0f);
	glVertex3f(-1.1f, -1.1f, -1.1f);
	glVertex3f(-1.1f, 1.1f, -1.1f);
	glVertex3f(-0.55f, -1.1f, -1.1f);
	glVertex3f(-0.55f, 1.1f, -1.1f);
	glVertex3f(0.0f, -1.1f, -1.1f);
	glVertex3f(0.0f, 1.1f, -1.1f);
	glVertex3f(0.55f, -1.1f, -1.1f);
	glVertex3f(0.55f, 1.1f, -1.1f);
	glVertex3f(1.1f, -1.1f, -1.1f);
	glVertex3f(1.1f, 1.1f, -1.1f);
	glVertex3f(-1.1f, -0.55f, -1.1f);
	glVertex3f(1.1f, -0.55f, -1.1f);
	glVertex3f(-1.1f, 0.0f, -1.1f);
	glVertex3f(1.1f, 0.0f, -1.1f);
	glVertex3f(-1.1f, 0.55f, -1.1f);
	glVertex3f(1.1f, 0.55f, -1.1f);
	glEnd();
}
